import pandas as pd
import pickle
from decision_company import read_csv_file, extract_year, bind_dataframe, aggregate_data

atp_tennis = read_csv_file('atp_tennis.csv')

# Group the DataFrame by year and surface type, and compute the average win/loss ratio
player_data['Year'] = extract_year(player_data, 'Date')
grouped_data = bind_dataframe(player_data, ['Year', 'Surface'])
agg_dict = {'Win_Loss_Ratio': 'mean'}
yearly_surface_data = aggregate_data(grouped_data, agg_dict).reset_index()

print(yearly_surface_data)
pickle.dump(yearly_surface_data,open("./ref_result/yearly_surface_data.pkl","wb"))